;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;
;;; sample file of .emacs
;;;
;
; This is just a sample. You should customize as you like...
;

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;
;;; Site configuration
;;;

;(autoload 'mew "mew" nil t)
;(autoload 'mew-send "mew" nil t)
;(setq mew-mail-domain-list '("your mail domain"))
;(setq mew-icon-directory "icon directory")

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;
;;; Window tips
;;;

;; If you use XEmacs and your video chip provides only limited
;; color map(e.g. 256), put the following line to avoid exhaustion
;; of colors.
;(setq mew-demo-picture nil)

(cond
 ((eq window-system 'x)
  (cond
   ((string-match "^19" emacs-version)
    (setq hilit-mode-enable-list  nil
	  hilit-background-mode   'light
	  hilit-inhibit-hooks     nil
	  hilit-inhibit-rebinding nil)
    (require 'hilit19)
    ;;
    (add-hook 'mew-message-hook
	      'hilit-rehighlight-buffer-quietly)
    (hilit-set-mode-patterns 
     '(mew-message-mode)
     '(("^Subject:.*$" nil msg-subject)
       ("^From:.*$" nil msg-from)
       ("^X-.*:.*$" nil msg-quote)
       ("^[A-Za-z][A-Za-z0-9-]+:" nil msg-header)))
    ;;
    (add-hook 'mew-draft-mode-hook
	      'hilit-rehighlight-buffer-quietly)
    (hilit-set-mode-patterns 
     '(mew-draft-mode)
     '(("^Subject:.*$" nil msg-subject)
       ("^From:.*$" nil msg-from)
       ("^>.*$" nil msg-quote)
       ("^[A-Za-z][A-Za-z0-9-]+:" nil msg-header)))
    )
   )
  (cond
   ((string-match "XEmacs" emacs-version)
    (set-face-font
     'default
     '(
       ;; Europa
       "-*-fixed-medium-r-*--14-*-iso8859-1"
       "-*-fixed-medium-r-*--*-iso8859-1"
       "-*-fixed-medium-r-*--*-iso8859-2"
       "-*-fixed-medium-r-*--*-iso8859-3"
       "-*-fixed-medium-r-*--*-iso8859-4"
       "-*-fixed-medium-r-*--*-iso8859-7"
       "-*-fixed-medium-r-*--*-iso8859-8"
       "-*-fixed-medium-r-*--*-iso8859-5"
       "-*-fixed-medium-r-*--*-iso8859-9"
       ;; Japanese
       "-*-fixed-medium-r-*--14-*-jisx0201.1976-*"
       "-*-fixed-medium-r-*--14-*-jisx0208.1983-*"
       "-*-fixed-medium-r-*--14-*-jisx0212*-*"
       "-*-fixed-medium-r-*--*-jisx0201.1976-*"
       "-*-fixed-medium-r-*--*-jisx0208.1983-*"
       "-*-fixed-medium-r-*--*-jisx0212*-*"
       ;; Chinese fonts
       "-*-*-medium-r-*--*-gb2312.1980-*"
       "-*-fixed-medium-r-*--*-cns11643*-*"
       "-*-fixed-medium-r-*--*-big5*-*"
       "-*-fixed-medium-r-*--*-sisheng_cwnn-0"
       ;; Korean
       "-*-mincho-medium-r-*--*-ksc5601.1987-*"
       ;; Thai
       "-*-fixed-medium-r-*--*-tis620.2529-1"
       )
     'global '(mule-fonts))
;    (add-hook 'mew-message-hook
;	      (function 
;	       (lambda ()
;		 (if mew-xemacs-p
;		     (highlight-headers (point-min) (point-max) nil)))))
    (require 'highlight-headers)
    (set-face-foreground 'message-headers "blue")
    (set-face-foreground 'message-highlighted-header-contents "firebrick")
    (set-face-foreground 'message-header-contents "purple")
;    (set-face-foreground 'message-cited-text "purple")
    (setq highlight-headers-hack-x-face-p t);; X-Face
;    (setq highlight-headers-highlight-citation-too nil)
    (set-specifier scrollbar-height 0)
    )
   )
  )
 (t
  ;; Command line (emacs/mule/xemacs -nw)
  (setq mew-demo nil)
  )
 )

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;
;;; Citation tip
;;;
;;;
;;; From: Kazuhiko Yamamoto <kazu@is.aist-nara.ac.jp>
;;; Subject: Hello World
;;; Date: Thu, 08 Dec 1994 11:44:08 +0900
;;; Message-Id: <199509291309.WAA21663@decpc07.aist-nara.ac.jp>
;;;
;;; kazu> The quick brown fox jumped over the very lazy dog.
;;;

(setq mew-cite-fields '("From:" "Subject:" "Date:" "Message-ID:"))
(setq mew-cite-format "From: %s\nSubject: %s\nDate: %s\nMessage-ID: %s\n\n")
(setq mew-cite-prefix-function 'mew-cite-prefix-username)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;
;;; ispell-message for Mew
;;;
;;;	You should apply ispell.el.patch to ispell.el.
;;;

(add-hook 'mew-send-hook 'ispell-message)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;
;;; pick macro
;;;

;; Maybe inclusion in mew-init-hook is proper.
(mew-pick-define-macro "-tocc #" "-to # -or -cc #")
(mew-pick-define-macro "-yesterday" "-after yesterday")
(mew-pick-define-macro "-Mew" "-tocc mew-dist")

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;
;;; XEmacs
;;;

(cond
 ((string-match "XEmacs" emacs-version)
  (setq zmacs-regions nil)
  (setq url-be-asynchronous t)
  (setq-default buffer-file-coding-system 'iso-2022-jp)
  (setq keyboard-coding-system    'iso-2022-jp)
  (setq terminal-coding-system    'iso-2022-jp)
  (add-menu-item '("Apps") "Read Mail (Mew)" 'mew t "Read Mail (VM)...")
  (add-menu-item '("Apps") "Send Mail (Mew)" 'mew-send t "Read Mail (VM)...")
  (delete-menu-item '("Apps" "Read Mail (VM)..."))
  (delete-menu-item '("Apps" "Read Mail (MH)..."))
  (delete-menu-item '("Apps" "Send mail..."))
  (setq toolbar-mail-reader 'Mew)
  (setq toolbar-mail-commands-alist
	(cons '(Mew . mew) toolbar-mail-commands-alist))
  )
 )

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;
;;; For OS/2 users
;;;

(cond
 ((eq system-type 'OS/2)
  (defalias 'make-symbolic-link 'copy-file))
 )

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;
;;; Unstable OSes
;;;

;; If pipe of your OS is not stable, both 'inc' and 'scan' don't
;; succeed. If so, add the following.
;(setq mew-connection-type1 t) ;; use PTY

;;;
;;; End
;;;
