;;;			    mew-virtual.el
;;;
;;;	      Copyright (C) 1996-1997  Kazuhiko Yamamoto
;;;
;;;		   This emacs lisp library conforms
;;;		GNU GENERAL PUBLIC LICENSE Version 2.
;;;
;;; Author:  Kazuhiko Yamamoto <kazu@is.aist-nara.ac.jp>
;;; Created: October  2, 1996
;;; Revised: March   30, 1997
;;;

(defconst mew-virtual-version "mew-virtual.el version 0.07")

(require 'mew)

(defvar mew-virtual-mode-map    nil)

(if mew-virtual-mode-map
    ()
  (setq mew-virtual-mode-map (make-sparse-keymap))
  (define-key mew-virtual-mode-map " "    'mew-summary-show)
  (define-key mew-virtual-mode-map "."    'mew-summary-display)
  (define-key mew-virtual-mode-map "<"    'mew-summary-display-top)
  (define-key mew-virtual-mode-map ">"    'mew-summary-display-bottom)
  (define-key mew-virtual-mode-map "\177" 'mew-summary-prev-page)
  (define-key mew-virtual-mode-map "\r"   'mew-summary-scroll-up)
  (define-key mew-virtual-mode-map "\e\r" 'mew-summary-scroll-down)
  (define-key mew-virtual-mode-map "g"    'mew-summary-goto-folder)
  (define-key mew-virtual-mode-map "j"    'mew-summary-jump-message)
  (define-key mew-virtual-mode-map "i"    'mew-summary-inc)
  (define-key mew-virtual-mode-map "a"    'mew-summary-reply)
  (define-key mew-virtual-mode-map "A"    'mew-summary-reply-with-citation)
  (define-key mew-virtual-mode-map "E"    'mew-summary-reedit)
  (define-key mew-virtual-mode-map "\ee"  'mew-summary-edit-again)
  (define-key mew-virtual-mode-map "f"    'mew-summary-forward)
  (define-key mew-virtual-mode-map "F"    'mew-summary-multi-forward)
  (define-key mew-virtual-mode-map "r"    'mew-summary-redist)
  (define-key mew-virtual-mode-map "@"    'mew-summary-mark-mark)
  (define-key mew-virtual-mode-map "*"    'mew-summary-mark-hop)
  (define-key mew-virtual-mode-map "y"    'mew-summary-save)
  (define-key mew-virtual-mode-map "u"    'mew-summary-undo)
  (define-key mew-virtual-mode-map "U"    'mew-summary-undo-all)
  (define-key mew-virtual-mode-map "n"    'mew-summary-display-down)
  (define-key mew-virtual-mode-map "p"    'mew-summary-display-up)
  (define-key mew-virtual-mode-map "N"    'mew-summary-display-hop-down)
  (define-key mew-virtual-mode-map "P"    'mew-summary-display-hop-up)
  (define-key mew-virtual-mode-map "w"    'mew-summary-send)
  (define-key mew-virtual-mode-map "B"    'mew-summary-burst)
  (define-key mew-virtual-mode-map "Z"    'mew-status-update)
  (define-key mew-virtual-mode-map "#"    'mew-summary-print)
  (define-key mew-virtual-mode-map "|"    'mew-summary-pipe-message)
  (define-key mew-virtual-mode-map "q"    'mew-summary-suspend)
  (define-key mew-virtual-mode-map "Q"    'mew-summary-quit)
  (define-key mew-virtual-mode-map "\C-c\C-s" 'mew-summary-isearch-forward)
  (define-key mew-virtual-mode-map "\C-c\C-r" 'mew-summary-isearch-backward)
  (define-key mew-virtual-mode-map "\C-c\C-o" 
    'mew-summary-jump-to-draft-buffer)
  (define-key mew-virtual-mode-map "\el"  'mew-summary-recenter)
  (define-key mew-virtual-mode-map "\et"  'mew-summary-uudecode)
  (define-key mew-virtual-mode-map "\C-c\C-l"
    'mew-summary-convert-local-charset)
  (define-key mew-virtual-mode-map "\es"  'mew-summary-unshar)
  (define-key mew-virtual-mode-map "v"    'mew-summary-toggle-disp-msg)
  (define-key mew-virtual-mode-map "\ea"  'mew-summary-toggle-analysis)
  (define-key mew-virtual-mode-map "\C-c\C-x" 'mew-summary-x-face)
  (define-key mew-virtual-mode-map "\C-c\C-q" 'mew-kill-buffer)
  )

;;;
;;; Virtual mode
;;;

(defun mew-virtual-mode ()
  "Major mode for reading picked messages over multiple folders.
The keys that are defined for this mode are:

SPC	Read through messages. See mew-summary-show-direction to set 
	'up,'down,'next(current direction) or 'stop. Default is 'down.
DEL	Back scroll this message.
	Unnecessary header fields are hidden over the window. Type DEL
	to see them when message are displayed.
.	Display this message or part. 
	If without MIME analysis, force to analyze this message.

RET	1 line scroll up this message.
ESC RET 1 line scroll down this message.

C-n	Go to the next line.
C-p	Go to the previous line.
n	Display below message or part.
p	Display above message or part.
N	Jump to below * marked message or display below message
	around multipart.
P	Jump to above * marked message or display above message
	around multipart.
j	Jump to a message according to inputed number.

i	Incorporate +inbox asynchronously.
g	Go to inputed folder.

w	Prepare draft to send a message.
a	Reply to this message or this part.
A	Reply to this message and insert it in draft buffer.
f	Forward this message as MIME format.
F	Forward @ marked messages as MIME format.
E	Edit this message again to send. In a draft folder, it just edit
	the message. Otherwise, copy the message to draft folder, then
	edit.
r	Re-distribute this message with Resent-To: and Resent-Cc:.

v	Toggle summary window only and summary & message windows.
	If you select summary window only, \"D\" never displays the 
	next message. So, you can set D marks quickly.
ESC a	Toggle with/out MIME analysis.
ESC l	Recenter this folder.

*	Mark this message with \"*\". Use N or P to jump to * marked message.
@	Mark this message with \"@\" for F, ESC s, and ESC t.
u	Cancel mark on this message.
U	Cancel all inputed mark.

C-cC-s	Incremental search forward on the message buffer.
C-cC-r	Incremental search backward on the message buffer.

ESC s	Apply unshar on @ marked messages.
ESC t	Apply uudecode on @ marked messages.

y	Copy this message or save this part as inputed file name.
#	Print this message or this part.
|	Pipe this message.

S	Sort messages in this folder.
O	Pack messages in this folder.

B	Burst messages encapsulated in MIME.

q	Switch to other buffer.
Q	Exit mew.
C-cC-q	Kill this buffer.

C-cC-l	Localize the transformed charset.
C-cC-x	Display xface.

Z	Update aliases and folders list. If you create a new alias or folder
	with native MH, try this.

"
  (interactive)
  (setq major-mode 'mew-virtual-mode)
  (setq mode-name "Virtual")
  (use-local-map mew-virtual-mode-map)
  (setq buffer-read-only t)
  (setq truncate-lines t)
  (setq selective-display t)
  (setq selective-display-ellipses nil)
  (if (equal (nth (- (length mode-line-format) 2) mode-line-format)
	     '(-3 . "%p"))
      (setq mode-line-format
	    (let ((mlf (copy-sequence mode-line-format))
		  (l (length mode-line-format)))
	      (setcdr (nthcdr (- l 3) mlf)
		      '("[" mew-summary-buffer-left-msgs " more]" "-%-"))
	      mlf)
	    ))
  (if mew-xemacs-p
      (progn
	(if mew-icon-p
	    (set-specifier default-toolbar
			   (cons (current-buffer) mew-summary-toolbar)))
        (set-buffer-menubar current-menubar)
        (add-submenu nil mew-summary-mode-menu-spec)
	))
  (if mew-highlight-lines-use
      (if mew-xemacs-p
	  (setq mode-motion-hook 'mode-motion-highlight-line)
	(if (save-excursion 
	      (goto-char (point-min))
	      (not (overlays-at (point))))
	    (mew-summary-highlight-lines-region (point-min) (point-max)))))
  (run-hooks 'mew-virtual-mode-hook)
  )

(defun mew-virtual-folder-message ()
  (interactive)
  (looking-at "^ *\\([0-9]+\\).*\r\\(.*\\)$")
  (message "%s" (mew-match 2))
  )

(defun mew-virtual-scan (vfolder pickargs folders)
  (set-buffer (get-buffer-create vfolder))
  (mew-virtual-mode)
  (mew-window-configure (current-buffer) 'summary)
  (mew-current-set 'message nil)
  (mew-current-set 'part nil)
  (mew-current-set 'cache nil)
  (setq mew-summary-buffer-direction 'down)
  (if (null (mew-summary-exclusive-p))
      ()
    (condition-case nil
	(let ((process-connection-type mew-connection-type1))
	  (message "Scanning %s ..." vfolder)
	  (let ((buffer-read-only nil))
	    (erase-buffer))
	  (goto-char (point-max))
	  (setq mew-summary-buffer-process
		(apply (function start-process)
		       "Scann" 
		       (current-buffer) 
		       mew-prog-vscan
		       "--scan"
		       "-noclear" "-noheader"
		       "-width"
		       (if (< (window-width) 80)
			   "80"
			 (int-to-string (window-width)))
		       (if pickargs 
			   (cons "--pick" (append pickargs folders))
			 folders
			 )))
	  (mew-set-process-cs mew-summary-buffer-process
			      mew-cs-virtual mew-cs-noconv)
	  (set-process-filter mew-summary-buffer-process
			      'mew-summary-scan-filter)
	  (set-process-sentinel mew-summary-buffer-process
				'mew-virtual-scan-sentinel)
	  (process-kill-without-query mew-summary-buffer-process)
	  )
      (quit
       (set-process-sentinel mew-summary-buffer-process nil)
       (setq mew-summary-buffer-process nil)
       (setq mew-summary-buffer-string nil)
       ))
    ))

(defun mew-summary-virtual ()
  (interactive)
  (let ((name (concat 
	       "++" 
	       (mew-input-string "Virtual folder name %s(%s): " 
				 "" ;; dummy
				 "virtual")))
	(folders (mew-input-folders (buffer-name)))
	(pattern (mew-pick-input-pattern)))
    (mew-virtual-scan name pattern folders)
    )
  )

(defun mew-virtual-scan-sentinel (process event)
  (save-excursion
    (set-buffer (process-buffer process)) ;; just in case
    (set-buffer-modified-p nil)
    (message "Scanning %s ... done" (buffer-name))
    (if mew-summary-buffer-string
	(if (string-match "^scan: no messages" mew-summary-buffer-string)
	    (message "No messages in %s" (buffer-name))
	  ;; need to hack
	  (let ((buffer-read-only nil))
	    (goto-char (point-max))
	    (insert mew-summary-buffer-string)
	    (goto-char (point-min))
	    (keep-lines mew-summary-message-regex))
	  ))
    (set-process-sentinel mew-summary-buffer-process nil)
    (setq mew-summary-buffer-process nil)
    (setq mew-summary-buffer-string nil)
    ))

(provide 'mew-virtual)
