;;;			     mew-scan.el
;;;
;;;	      Copyright (C) 1996-1997  Kazuhiko Yamamoto
;;;
;;;		   This emacs lisp library conforms
;;;		GNU GENERAL PUBLIC LICENSE Version 2.
;;;
;;; Author:  Kazuhiko Yamamoto <kazu@is.aist-nara.ac.jp>
;;; Created: October 2, 1996
;;; Revised: April   2, 1997
;;;

(defconst mew-scan-version "mew-scan.el version 0.08")

(require 'mew)

;;
;; inc
;;

(defvar mew-summary-inc-start nil)

(defun mew-summary-inc ()
  (interactive)
  (mew-summary-folder-cache-manage mew-inbox)
  (if (and mew-summary-cache-use (mew-summary-folder-dir-newp))
      (progn
	(mew-summary-scan-body mew-inbox (mew-input-range mew-inbox))
	;; scan the gap
	(if mew-xemacs-p
	    (while mew-summary-buffer-process (accept-process-output))
	  (while mew-summary-buffer-process (sit-for 1)))
	))
  (mew-summary-inc-body)
  )

;; drop folder is meaningless at present.
(defun mew-summary-inc-body ()
  (set-buffer (get-buffer mew-inbox)) ;; just in case
  (buffer-disable-undo (current-buffer))
  (if (not (equal major-mode 'mew-summary-mode)) (mew-summary-mode))
  (mew-window-configure (current-buffer) 'summary)
  (mew-current-set 'message nil)
  (mew-current-set 'part nil)
  (mew-current-set 'cache nil)
  (setq mew-summary-buffer-direction 'down)
  (mew-decode-syntax-delete)
  (if (null (mew-summary-exclusive-p))
      ()
    (condition-case nil
	(let ((process-connection-type mew-connection-type1))
	  (message "Incing ...")
	  (goto-char (point-max))
	  (setq mew-summary-inc-start (point))
	  (setq mew-summary-buffer-string nil) ; just in case
	  (setq mew-summary-buffer-process
		(apply (function start-process)
		       "Inc"
		       (current-buffer) 
		       mew-prog-inc
		       "-width"
		       (if (< (window-width) 80)
			   "80"
			 (int-to-string (window-width)))
		       mew-prog-inc-arg-list))
	  (mew-set-process-cs mew-summary-buffer-process
			      mew-cs-scan mew-cs-noconv)
	  (set-process-filter mew-summary-buffer-process
			      'mew-summary-inc-filter)
	  (set-process-sentinel mew-summary-buffer-process
				'mew-summary-inc-sentinel)
	  (process-kill-without-query mew-summary-buffer-process)
	  )
      (quit
       (set-process-sentinel mew-summary-buffer-process nil)
       (setq mew-summary-inc-start nil)
       ;; xxx buffer local so set-buffer ???
       (setq mew-summary-buffer-process nil)
       (setq mew-summary-buffer-string nil)
       )
      )
    ))

(defun mew-summary-inc-filter (process string)
  (save-excursion
    (set-buffer (process-buffer process)) ;; just in case
    (setq mew-summary-buffer-string 
	  (concat mew-summary-buffer-string string)) ;; nil can concat
    (let ((buffer-read-only nil)
	  (po (point-max)))
      (if (string-match "^Password" mew-summary-buffer-string)
	  (progn
	    (setq mew-summary-buffer-string "")
	    (process-send-string
	     process
	     (format "%s\n" (mew-read-passwd "Enter password : ")))
	    ))
      (if (string-match "^Incorpo.*\n\n" mew-summary-buffer-string)
	  (setq mew-summary-buffer-string
		(substring mew-summary-buffer-string (match-end 0))))
      (while (string-match "^ *[0-9]+\\(.\\).*\n" mew-summary-buffer-string)
	;; leave mew-summary-buffer-string if "inc: no messages"
	(goto-char (point-max))
	(if (not (equal "+" (mew-match 1 mew-summary-buffer-string)))
	    ;; never delete the character after message number
	    (insert (substring mew-summary-buffer-string 0 (match-end 0)))
	  ;; message number
	  (insert (substring mew-summary-buffer-string 0 (match-beginning 1)))
	  ;; delete "+"
	  (insert " ")
	  ;; the rest of line
	  (insert (substring mew-summary-buffer-string
			     (match-end 1)
			     (match-end 0)))
	  )
	(setq mew-summary-buffer-string
	      (substring mew-summary-buffer-string (match-end 0)))
	)
      (mew-summary-highlight-lines-region po (point))
      )))

(defun mew-summary-inc-sentinel (process event)
  (save-excursion
    (set-buffer (process-buffer process)) ;; just in case
    (message "Incing ... done") ;; error message overrides
    (if mew-summary-buffer-string
	(cond 
         ((string-match "^inc: no mail" mew-summary-buffer-string)
          (message "No new mail"))
	 ((string-match "^inc: \\(.*\\)" mew-summary-buffer-string)
	  (message "Inc error: %s" (mew-match 1 mew-summary-buffer-string)))
	 (t 
	  ;; save cache only when success
	  (if mew-summary-cache-use (mew-summary-folder-cache-save))
	  ;; again to override write buffer message
	  (message "Incing ... done") ;; error message overrides
	  (let ((buffer-read-only nil))
	    (goto-char (point-max))
	    (insert mew-summary-buffer-string)
	    (goto-char mew-summary-inc-start)
	    (keep-lines (concat mew-summary-message-regex
				"\\|"
				mew-summary-part-regex)))
	  )
	 ))
    (set-buffer-modified-p nil)
    ;; xxx if killed, we can't clear sentinel
;    (set-process-sentinel mew-summary-buffer-process nil)
    (setq mew-summary-inc-start nil)
    (setq mew-summary-buffer-process nil)
    (setq mew-summary-buffer-string nil)
    (run-hooks 'mew-summary-inc-sentinel-hook)
    ))

;;
;; scan
;;

(defun mew-summary-scan ()
  (interactive)
  (let* ((folder (buffer-name)))
    (mew-summary-folder-cache-manage folder)
    (mew-summary-folder-mark-exec)
    (goto-char (point-max))
    (if (null (mew-member folder mew-folders))
	(setq mew-folders (cons folder mew-folders)))
    (if (or (interactive-p)
	    (and mew-summary-cache-use
		 (mew-summary-folder-dir-newp)))
	(mew-summary-scan-body folder (mew-input-range folder)))
    ))

(defun mew-summary-scan-body (folder range-erase)
  (let ((range (car range-erase)) 
	(erase (car (cdr range-erase))))
    (set-buffer (get-buffer folder)) ;; just in case
    (buffer-disable-undo (current-buffer))
    (if (not (equal major-mode 'mew-summary-mode)) (mew-summary-mode))
    (mew-window-configure (current-buffer) 'summary)
    (mew-current-set 'message nil)
    (mew-current-set 'part nil)
    (mew-current-set 'cache nil)
    (setq mew-summary-buffer-direction 'down)
    (if (null (mew-summary-exclusive-p))
	()
      (condition-case nil
	  (let ((process-connection-type mew-connection-type1))
	    (message "Scanning %s ..." folder)
	    (let ((buffer-read-only nil))
	      (if (equal erase 'erase)
		  (erase-buffer)
		(goto-char (point-max))))
	    (if (null (listp range)) (setq range (list range)))
	    (setq mew-summary-buffer-string nil) ; just in case
	    (setq mew-summary-buffer-process
		  (apply (function start-process) 
			 "Scann" 
			 (current-buffer) 
			 mew-prog-scan
			 folder
			 "-noclear" "-noheader"
			 "-width"
			 (if (< (window-width) 80)
			     "80"
			   (int-to-string (window-width)))
			 (append mew-prog-scan-arg-list range)
			 ))
	    (mew-set-process-cs mew-summary-buffer-process
				mew-cs-scan mew-cs-noconv)
	    (set-process-filter mew-summary-buffer-process
				'mew-summary-scan-filter)
	    (set-process-sentinel mew-summary-buffer-process
				  'mew-summary-scan-sentinel)
	    (process-kill-without-query mew-summary-buffer-process)
	    )
	(quit
	 (set-process-sentinel mew-summary-buffer-process nil)
	 (setq mew-summary-buffer-process nil)
	 (setq mew-summary-buffer-string nil)
	 ))
      )
    ))

(defun mew-summary-scan-filter (process string)
  (save-excursion
    (set-buffer (process-buffer process)) ;; just in case
    (setq mew-summary-buffer-string 
	  (concat mew-summary-buffer-string string)) ;; nil can concat
    (let ((buffer-read-only nil)
	  (po (point-max)))
      (while (string-match "^ *[0-9]+\\(.\\).*\n" 
			   mew-summary-buffer-string)
	;; leave mew-summary-buffer-string if "scan: no messages"
	(goto-char (point-max))
	(if (not (equal "+" (mew-match 1 mew-summary-buffer-string)))
	    ;; never delete the character after message number
	    (insert (substring mew-summary-buffer-string 0 (match-end 0)))
	  ;; message number
	  (insert (substring mew-summary-buffer-string 0 (match-beginning 1)))
	  ;; delete "+"
	  (insert " ")
	  ;; the rest of line
	  (insert (substring mew-summary-buffer-string
			     (match-end 1)
			     (match-end 0)))
	  )
	(setq mew-summary-buffer-string
	      (substring mew-summary-buffer-string (match-end 0)))
	)
      (mew-summary-highlight-lines-region po (point))
      )))

(defun mew-summary-scan-sentinel (process event)
  (save-excursion
    (set-buffer (process-buffer process)) ;; just in case
    (message "Scanning %s ... done" (buffer-name))
    (if mew-summary-buffer-string
	(cond
	 ((string-match "^scan: no messages" mew-summary-buffer-string)
	  (message "No messages in %s" (buffer-name)))
	 (t 
	  ;; save only when success
	  (if mew-summary-cache-use (mew-summary-folder-cache-save))
	  ;; again to override write buffer message
	  (message "Scanning %s ... done" (buffer-name)) 
	  (let ((buffer-read-only nil))
	    (goto-char (point-max))
	    (insert mew-summary-buffer-string)
	    (goto-char (point-min))
	    (keep-lines mew-summary-message-regex))
	  )
	 ))
    (set-buffer-modified-p nil)
    ;; xxx if killed, we can't clear sentinel
;    (set-process-sentinel mew-summary-buffer-process nil)
    (setq mew-summary-buffer-process nil)
    (setq mew-summary-buffer-string nil)
    (run-hooks 'mew-summary-scan-sentinel-hook)
    ))

(provide 'mew-scan)
