;;;			     mew-mule2.el
;;;
;;;		Copyright (C) 1997  Kazuhiko Yamamoto
;;;
;;;		   This emacs lisp library conforms
;;;		GNU GENERAL PUBLIC LICENSE Version 2.
;;;
;;; Author:  Kazuhiko Yamamoto <kazu@is.aist-nara.ac.jp>
;;; Created: March 20, 1997
;;; Revised: 
;;;

(defconst mew-mule2-version "mew-mule2.el version 0.01")

;;
;; Charset
;;

(defvar mew-cs-noconv       *noconv*)
(defvar mew-cs-autoconv     *autoconv*)
(defvar mew-cs-7bit         *iso-2022-ss2-7*)
(defvar mew-cs-7bit-crlf    *iso-2022-ss2-7*dos)

(defvar mew-cs-mime-trans   *iso-2022-ss2-7*)
(defvar mew-cs-rfc822-trans *iso-2022-ss2-7*) 
(defvar mew-cs-draft        *iso-2022-jp*)
(defvar mew-cs-scan         *iso-2022-jp*) ;; *iso-2022-ss2-7*?
(defvar mew-cs-spool        *noconv*)
(defvar mew-cs-infile       *autoconv*)
(defvar mew-cs-outfile      *iso-2022-jp*)
(defvar mew-cs-virtual      *iso-2022-jp*unix) ;; ^M as it is

(defvar mew-mule-character-set
  (list 
   (if (boundp '*iso-8859-1*)	;; Latin-1
       (list lc-ltn1	*iso-8859-1*		"iso-8859-1")
     (if (boundp '*ctext*) ;; for old mule
	 (list lc-ltn1	*ctext*		"iso-8859-1")))
   (if (boundp '*iso-8859-2*)	;; Latin-2
       (list lc-ltn2	*iso-8859-2*		"iso-8859-2"))
   (if (boundp '*iso-8859-3*)	;; Latin-3
       (list lc-ltn3	*iso-8859-3*		"iso-8859-3"))
   (if (boundp '*iso-8859-4*)	;; Latin-4
       (list lc-ltn4	*iso-8859-4*		"iso-8859-4"))
   (if (boundp '*iso-8859-5*)	;; Cyrillic
       (list lc-crl		*iso-8859-5*	"iso-8859-5"))
   (if (boundp '*iso-8859-6*)	;; Arabic
       (list lc-arb		*iso-8859-6*	"iso-8859-6"))
   (if (boundp '*iso-8859-7*)	;; Greek
       (list lc-grk		*iso-8859-7*	"iso-8859-7"))
   (if (boundp '*iso-8859-8*)	;; Hebrew
       (list lc-hbw		*iso-8859-8*	"iso-8859-8"))
   (if (boundp '*iso-8859-9*)	;; Latin-5
       (list lc-ltn5	*iso-8859-9*		"iso-8859-9"))
   (if (boundp '*iso-2022-jp*);; Japanese
	 (list lc-jp		*iso-2022-jp*	"iso-2022-jp"))
   (if (boundp '*iso-2022-kr*);; Korean
       (list lc-kr		*iso-2022-kr*	"iso-2022-kr"))
   (if (boundp '*iso-2022-ss2-7*);; Chinese xxx
       (list lc-cn		*iso-2022-ss2-7* "iso-2022-cn"))
   (if (boundp '*iso-2022-ss2-7*)
       (list t		*iso-2022-ss2-7* "iso-2022-jp-2"))
   ;; for charset to symbol
   (if (boundp '*euc-japan*)
       (list nil           *euc-japan*	  "euc-japan")) 
   (if (boundp '*euc-korea*)
       (list nil           *euc-korea*          "euc-korea"))
   (if (boundp '*sjis*)
       (list nil           *sjis*               "sjis")) 
   )
  )

;;
;; Charset2
;;

(defvar mew-mule-mime-charset 
  (mapcar (function (lambda (x) (nth 2 x))) mew-mule-character-set))

(defmacro mew-mule-lc-attr (lc alist)
  (` (mew-assoc (, lc) (, alist) 0 nil)))

(defmacro mew-mule-lc-attr-by-charset (lc alist)
  (` (mew-assoc (, lc) (, alist) 2 t)))

(defmacro mew-mule-lc-content (attr)
  (` (car (cdr (cdr (, attr))))))

(defmacro mew-mule-lc-symbol (attr)
  (` (car (cdr (, attr)))))

(defun mew-charset-to-symbol (charset)
  (if charset
      (mew-mule-lc-symbol 
       (mew-mule-lc-attr-by-charset charset mew-mule-character-set))
    nil))

(defmacro mew-mule-content-attr (content alist)
  (` (mew-assoc2 (, content) (, alist) 2 t)))

(defmacro mew-mule-content-coding (attr)
  (` (car (cdr (, attr)))))

;;
;; Charset guess
;;

(defun mew-charset-guess-region (beg end)
  (interactive "r")
  "Guess minimum character set name."
  (let* ((lc (find-charset-region beg end))
	 (len (length lc)))
    (cond
     ((equal len 0) "us-ascii")
     ((equal len 1)
      (mew-mule-lc-content 
       (mew-mule-lc-attr (car lc) mew-mule-character-set)))
     (t "iso-2022-jp-2")
     )
    ))

(defun mew-charset-guess-string (str)
  (interactive)
  "Guess minimum character set name."
  (let* ((lc (find-charset-string str))
	 (len (length lc)))
    (cond
     ((equal len 0) "us-ascii")
     ((equal len 1)
      (mew-mule-lc-content 
       (mew-mule-lc-attr (car lc) mew-mule-character-set)))
     (t "iso-2022-jp-2")
     )
    ))

;;
;; Charset conversion
;;

;; to internal
(defun mew-cs-decode-region (beg end cs &optional charsetp)
  (if (null cs)
      ()
    (let (from attr)
      (if (null charsetp)
	  (setq from cs)
	(setq cs (downcase cs))
	(setq attr (mew-mule-content-attr cs mew-mule-character-set))
	(setq from (mew-mule-content-coding attr)))
      (if from (code-convert-region beg end from *internal*))
      )
    ))

;; to extenal
(defun mew-cs-encode-region (beg end cs &optional charsetp)
  (if (null cs)
      ()
    (let (to attr)
      (if (null charsetp)
	  (setq to cs)
	(setq cs (downcase cs))
	(setq attr (mew-mule-content-attr cs mew-mule-character-set))
	(setq to (mew-mule-content-coding attr cs)))
      (if to (code-convert-region beg end *internal* to))
      )
    ))

;; to internal
(defun mew-cs-decode-string (str cs &optional charsetp)
  (if (null cs)
      ()
    (let (from attr)
      (if (null charsetp)
	  (setq from cs)
	(setq cs (downcase cs))
	(setq attr (mew-mule-content-attr cs mew-mule-character-set))
	(setq from (mew-mule-content-coding attr)))
      (if from (code-convert-string str from *internal*) str)
      )
    ))

;; to external
(defun mew-cs-encode-string (str cs &optional charsetp)
  (if (null cs)
      ()
    (let (to attr)
      (if (null charsetp)
	  (setq to cs)
	(setq cs (downcase cs))
	(setq attr (mew-mule-content-attr cs mew-mule-character-set))
	(setq to (mew-mule-content-coding attr)))
      (if to (code-convert-string str *internal* to) str)
      )
    ))

;;
;; Process environment
;;

(defun mew-set-process-cs (pro from-pro to-pro)
  (set-process-coding-system pro from-pro to-pro)
  )

(defmacro mew-plet (&rest body)
  (`(let ((call-process-hook nil)
	  (default-process-coding-system
	    (cons *noconv* *noconv*)))
      (,@ body))
   ))

(defmacro mew-piolet (input output &rest body)
  (`(let ((call-process-hook nil)
	  (default-process-coding-system
	    (cons (, input) (, output))))
      (,@ body))
   ))

(defmacro mew-flet (&rest body)
  (`(let ((file-coding-system          *noconv*)
	  (file-coding-system-for-read *noconv*))
      (,@ body))
   ))

(defmacro mew-frwlet (read write &rest body)
  (`(let ((file-coding-system          (, write))
	  (file-coding-system-for-read (, read)))
      (,@ body))
   ))

(provide 'mew-mule2)
