;;;			     mew-mule0.el
;;;
;;;		Copyright (C) 1997  Kazuhiko Yamamoto
;;;
;;;		   This emacs lisp library conforms
;;;		GNU GENERAL PUBLIC LICENSE Version 2.
;;;
;;; Author:  Kazuhiko Yamamoto <kazu@is.aist-nara.ac.jp>
;;; Created: March 20, 1997
;;; Revised: 
;;;

(defconst mew-mule0-version "mew-mule0.el version 0.01")

;;
;; Charset
;;

(defvar mew-cs-noconv       nil)
(defvar mew-cs-autoconv     nil)
(defvar mew-cs-7bit         nil)
(defvar mew-cs-7bit-crlf    nil)

(defvar mew-cs-mime-trans   nil)
(defvar mew-cs-rfc822-trans nil)
(defvar mew-cs-draft        nil)
(defvar mew-cs-scan         nil)
(defvar mew-cs-spool        nil)
(defvar mew-cs-infile       nil)
(defvar mew-cs-outfile      nil)
(defvar mew-cs-virtual      nil)

(defvar mew-mule-character-set nil)

;;
;; Charset2
;;

(defvar mew-mule-mime-charset  nil)

;;
;; Charset guess
;;

(defun mew-charset-guess-region (beg end)
  (interactive "r")
  "Guess minimum character set name."
  (save-excursion
    (goto-char beg)
    (if (re-search-forward "[\200-\377]" end t)
	"iso-8859-1"
      "us-ascii")
    ))

(defun mew-charset-guess-string (str)
  (interactive)
  "Guess minimum character set name."
  (if (string-match "[\200-\377]" str)
      "iso-8859-1"
    "us-ascii")
  )

;;
;; Charset conversion
;;

;; to internal
(defun mew-cs-decode-region (beg end cs &optional charsetp)
  )

;; to extenal
(defun mew-cs-encode-region (beg end cs &optional charsetp)
  )

;; to internal
(defun mew-cs-decode-string (str cs &optional charsetp)
  str
  )

;; to external
(defun mew-cs-encode-string (str cs &optional charsetp)
  str
  )

;;
;; Process environment
;;

(defun mew-set-process-cs (pro from-pro to-pro)
  )

(defmacro mew-plet (&rest body)
  (`(let ((call-process-hook nil))
      (,@ body))
   ))

(defmacro mew-piolet (input output &rest body)
  (`(let ((call-process-hook nil))
      (,@ body))
   ))

(defmacro mew-flet (&rest body)
  (`(let ()
      (,@ body))
   ))

(defmacro mew-frwlet (read write &rest body)
  (`(let ()
      (,@ body))
   ))

(provide 'mew-mule0)
