;;;			     mew-mime.el
;;;
;;;		Copyright (C) 1997  Kazuhiko Yamamoto
;;;
;;;		   This emacs lisp library conforms
;;;		GNU GENERAL PUBLIC LICENSE Version 2.
;;;
;;; Author:  Kazuhiko Yamamoto <kazu@is.aist-nara.ac.jp>
;;; Created: March 23, 1997
;;; Revised: April 21, 1997
;;;

(defconst mew-mime-version "mew-mime.el version 0.04")

(require 'mew)

(defvar mew-save-application/octet-stream-p t)

(defvar mew-eof-string nil
  "*A value inserted on the end of message buffer if non-nil.")

(defvar mew-mime-content-type-text-list
  '("Text/Plain" "Text/Html"
    "Application/Postscript")
  "Content-Type: list for text which are treated as text when encoded"
  )

(defvar mew-mime-content-type-multipart-list
  '("Multipart/Mixed" "Multipart/Alternative"
    ;;"Multipart/Digest" "Multipart/Parallel"
    )
  "Candidate of 'Content-Type: Multipart' when CT: is changed in draft buffer."
  )

(defvar mew-mime-content-type-binary-list
  '("Application/Octet-Stream"
    "Image/Jpeg" "Image/Gif" "Image/x-xwd" "Image/x-xbm" "Image/x-bmp"
    "Audio/Basic" "Video/Mpeg"
    )
  "Content-Type: list to save as binary file in mew-summary-save on Mule"
  )

(defvar mew-mime-content-type-others-list
  '("Message/Rfc822" "Message/External-body"
    "Application/X-Graph")
  )

(defvar mew-mime-content-type-list
  (append mew-mime-content-type-text-list
	  mew-mime-content-type-multipart-list
	  mew-mime-content-type-binary-list
	  mew-mime-content-type-others-list)
  "Candidate of Content-Type: when CT: is changed in draft buffer."
  )

(defvar 
 mew-mime-content-type
 (list
   (list 
    "multipart/*"
    nil
    nil
    nil
    (if (boundp 'mew-icon-multipart) mew-icon-multipart)
    )
   (list 
    "audio/basic"
    "\\.au$"
    "base64"
    (list mew-prog-shell (list mew-prog-shell-arg "cat - > /dev/audio") nil)
    (if (boundp 'mew-icon-audio) mew-icon-audio)
    )
   (list
    "image/gif"
    "\\.gif$"
    "base64"
    '("xv" ("-geometry" "+0+0") t)
    (if (boundp 'mew-icon-image) mew-icon-image)
    )
   (list
    "image/jpeg"
    "\\.jpe?g$"
    "base64"
    '("xv" ("-geometry" "+0+0") t)
    (if (boundp 'mew-icon-image) mew-icon-image)
    )
   (list
    "image/x-xwd"
    "\\.xwd$"
    "base64"
    '("xv" ("-geometry" "+0+0") t)
    (if (boundp 'mew-icon-image) mew-icon-image)
    )
   (list
    "image/x-xbm"
    "\\.xbm$"
    "base64"
    '("xv" ("-geometry" "+0+0") t)
    (if (boundp 'mew-icon-image) mew-icon-image)
    )
   (list
    "image/x-bmp"
    "\\.bmp$"
    "base64"
    '("xv" ("-geometry" "+0+0") t)
    (if (boundp 'mew-icon-image) mew-icon-image)
    )
   (list
    "image/.*"
    "^$"
    "base64"
    '("xv" ("-geometry" "+0+0") t)
    (if (boundp 'mew-icon-image) mew-icon-image)
    )
   (list
    "video/mpeg"
    "\\.mpe?g$"
    "base64"
    '("mpeg_play" () t)
    (if (boundp 'mew-icon-video) mew-icon-video)
    )
   (list
    "application/postscript"
    "\\.ps$"
    "quoted-printable"
    '("ghostview" ("-geom" "+0+0") t)
    (if (boundp 'mew-icon-application/postscript) 
	mew-icon-application/postscript)
    )
   (list
    "application/pgp-keys"
    "\\.pka$"
    nil
    '(mew-mime-pgp-keys () nil)
    (if (boundp 'mew-icon-unknown) mew-icon-unknown)
    )
   (list
    "application/octet-stream"
    "\\.tar\\.?g?z?$"
    "base64"
    '(mew-mime-application/octet-stream () nil)
    (if (boundp 'mew-icon-application/octet-stream)
	mew-icon-application/octet-stream)
    )
   (list
    "application/octet-stream"
    "\\.tgz$"
    "base64"
    '(mew-mime-application/octet-stream () nil)
    (if (boundp 'mew-icon-application/octet-stream)
	mew-icon-application/octet-stream)
    )
   (list
    "application/octet-stream"
    "\\.gz$"
    "base64"
    '(mew-mime-application/octet-stream () nil)
    (if (boundp 'mew-icon-application/octet-stream)
	mew-icon-application/octet-stream)
    )
   (list
    "application/octet-stream"
    "\\.Z$"
    "base64"
    '(mew-mime-application/octet-stream () nil)
    (if (boundp 'mew-icon-application/octet-stream)
	mew-icon-application/octet-stream)
    )
   (list
    "application/octet-stream"
    "\\.pgp$"
    "base64"
    '(mew-mime-application/octet-stream () nil)
    (if (boundp 'mew-icon-application/octet-stream)
	mew-icon-application/octet-stream)
    )
   (list
    "message/external-body" 
    "\\.ext$"
    nil
    '(mew-mime-external-body () nil)
    (if (boundp 'mew-icon-message/external-body)
	mew-icon-message/external-body)
    )
   (list
    "message/rfc822"
    "^[0-9]+$"
    nil
    '(mew-mime-message/rfc822 () nil)
    (if (boundp 'mew-icon-message/rfc822) mew-icon-message/rfc822)
    )
   (list
    "message/delivery-status"
    "^$"
    nil
    '(mew-mime-text/plain () nil)
    (if (boundp 'mew-icon-text) mew-icon-text)
    )
   (list
    "text/richtext"
    "\\.rtf$"
    nil
    '(mew-mime-text/plain () nil)
    (if (boundp 'mew-icon-text) mew-icon-text)
    )
   (list
    "text/plain"
    ".*"
    nil
    '(mew-mime-text/plain () nil)
    (if (boundp 'mew-icon-text) mew-icon-text)
    )
   (list
    "text/.*"
    "^$"
    nil
    '(mew-mime-text/plain () nil)
    (if (boundp 'mew-icon-text) mew-icon-text)
    )
   (list
    ".*" 
    "^$"
    nil
    '(mew-mime-application/octet-stream () nil)
    (if (boundp 'mew-icon-unknown) mew-icon-unknown)
    )
   )
 "(content-type filename encoding (program (options ...) async) icon)"
 )

;;
(defmacro mew-file-attr (filename alist)
  (` (mew-assoc2 (, filename) (, alist) 1 t)))

(defmacro mew-type-attr (filename alist)
  (` (mew-assoc2 (, filename) (, alist) 0 nil)))

;; for mapcar
(defun mew-file-content (attr)
  (car attr))

(defmacro mew-file-encoding (attr)
  (` (car (cdr (cdr (, attr))))))

;;
(defmacro mew-content-attr (content alist)
  (` (mew-assoc2 (, content) (, alist) 0 t)))

(defmacro mew-content-program (attr)
  (` (car (car (cdr (cdr (cdr (, attr))))))))

(defmacro mew-content-options (attr)
  (` (car (cdr (car (cdr (cdr (cdr (, attr)))))))))


(defmacro mew-content-async (attr)
  (` (car (cdr (cdr (car (cdr (cdr (cdr (, attr))))))))))

;;
;;
;;

(defun mew-mime-start-process (program options file)
  (let ((process-connection-type mew-connection-type1) pro)
    (message "Starting %s ..." program)
    (setq pro (apply (function start-process)
		     (format "*mew %s*" program)
		     mew-buffer-tmp ;; xxx
		     program
		     (append options (list file))))
    (set-process-sentinel pro 'mew-mime-start-process-sentinel)
    (message "Sending %s ... done" program)
    (setq mew-process-file-alist (cons (cons pro file) mew-process-file-alist))
    )
  t ;; to next part
  )

(defun mew-mime-start-process-sentinel (process event)
  (let ((al (assoc process mew-process-file-alist)))
    (if (cdr al) (delete-file (cdr al)))
    (setq mew-process-file-alist (mew-delq al mew-process-file-alist))
    ))

(defun mew-mime-call-process (program options file)
  (message "Calling %s ..." program)
  (apply (function call-process) program file nil nil options)
  (message "Calling %s ... done" program)
  t ;; to next part
  )

(defun mew-mime-text/plain (begin end &optional params)
  (if (> end begin)
      (save-excursion
	(set-buffer (mew-buffer-message))
	(let ((buffer-read-only nil))
	  (insert-buffer-substring (mew-current-get 'cache) begin end)
	  (if mew-eof-string
	      (progn
		(goto-char (point-max)) ;; necessary?
		(insert mew-eof-string)))
	  )
	(cond (mew-break-pages 
	       (goto-char (point-min))
	       (mew-message-narrow-to-page)
	       ))
	(set-buffer-modified-p nil) ;; xxx
	))
  )

(defun mew-mime-message/rfc822 (part)
  (let* ((hbegin (mew-syntax-get-begin part))
	 (hend   (mew-syntax-get-end   part))
	 (cache  (mew-current-get 'cache))
	 (buffer-read-only nil))
    (insert-buffer-substring cache hbegin hend)
    (if mew-decode-result (insert mew-decode-result))
    (insert "\n") ;; xxx
    (mew-header-arrange)
    (if (mew-syntax-singlepart-p (mew-syntax-get-part part))
	(mew-summary-display-part part nil 'non-erase)) ;; nil is single
    ;; display-part sets citation noheader
    (setq mew-message-citation 'header)
    (set-buffer-modified-p nil) ;; xxx
    ))

(defun mew-mime-application/octet-stream (begin end &optional params)
  (if (not mew-save-application/octet-stream-p)
      (mew-mime-text/plain begin end params)
    (if (not (mew-y-or-n-p "Save this part? "))
	()
      (save-excursion
	(set-buffer (mew-current-get 'cache))
	(mew-flet
	 (let* ((name (mew-syntax-get-member params "name"))
		(file (mew-input-filename nil name)))
	   (if (file-exists-p file)
	       (if mew-file-append-p
		   (write-region begin end file t)
		 (if (mew-y-or-n-p (format "File %s exists. Append it? "
					   (file-name-nondirectory file)))
		     (write-region begin end file t)
		   ()))
	     (write-region begin end file)
	     ))
	 ))
      )))

(provide 'mew-mime)
