;;;			      mew-env.el
;;;
;;;		Copyright (C) 1997  Kazuhiko Yamamoto
;;;
;;;		   This emacs lisp library conforms
;;;		GNU GENERAL PUBLIC LICENSE Version 2.
;;;
;;; Author:  Kazuhiko Yamamoto <kazu@is.aist-nara.ac.jp>
;;; Created: March  6, 1997
;;; Revised: March 25, 1997
;;;

(defconst mew-env-version "mew-env.el version 0.07")

(require 'mew)

(defvar mew-emacs-p  nil)
(defvar mew-xemacs-p nil)
(defvar mew-mule-p   nil)
(defvar mew-icon-p   nil)
(defvar mew-mule-version 0)

(if (featurep 'mule) (setq mew-mule-p t))

(cond
 ((string-match "XEmacs" emacs-version)
  (setq mew-emacs-p nil)
  (setq mew-xemacs-p t)
  (require 'mew-xemacs)
  (if (and (featurep 'xpm) (eq (console-type) 'x))
      (setq mew-icon-p t))
  (if (string-match "^19" emacs-version)
      (require 'mew-mule0)
    (require 'mew-mule3)
    (setq mew-mule-version 3))
  )
 (t
  (setq mew-emacs-p t)
  (setq mew-xemacs-p nil)
  (if (null mew-mule-p)
    (require 'mew-mule0)
    (if (= (string-to-int mule-version) 3)
      (progn
        (require 'mew-mule3)
        (setq mew-mule-version 3)
      )
      (require 'mew-mule2)
      (setq mew-mule-version 2)
    )
   )
  )
 )

(cond 
 (mew-xemacs-p
  (or (find-face 'underline)
      (progn (make-face 'underline)
	     (set-face-underline-p 'underline t)))
  (fset 'mew-overlayp (symbol-function 'extentp))
  (fset 'mew-make-overlay (symbol-function 'make-extent))
  (defun mew-move-overlay (overlay beg end &optional buffer)
    (set-extent-endpoints overlay beg end))
  (defun mew-overlay-put (overlay prop value)
    (set-extent-property overlay prop value))
  (require 'highlight-headers)
  (fset 'mew-buffer-substring 'buffer-substring)
  )
 (mew-emacs-p
  (fset 'mew-overlayp (symbol-function 'overlayp))
  (fset 'mew-make-overlay (symbol-function 'make-overlay))
  (fset 'mew-move-overlay (symbol-function 'move-overlay))
  (fset 'mew-overlay-put (symbol-function 'overlay-put))
  (require 'easymenu)
  (if (fboundp 'buffer-substring-no-properties)
      (fset 'mew-buffer-substring 'buffer-substring-no-properties)
    (defun mew-buffer-substring (beg end)
      "Return the text from BEG to END, without text properties, as a string."
      (let ((string (buffer-substring beg end)))
	(set-text-properties 0 (length string) nil string)
	string)))
  )
 )

;; to avoid competition with mh-e.el
(if (rassq 'mh-letter-mode auto-mode-alist)
    (setq auto-mode-alist
	  (delete (rassq 'mh-letter-mode auto-mode-alist)
		  auto-mode-alist)))

(defvar mew-connection-type1 nil
  "Connection type for many processes. t means PTY and nil means PIPE.
PIPE is usually recommended for speed but some OSes such as Linux 
requires PTY.")

(defvar mew-connection-type2 t 
  "Connection type for processes that requires a password. 
This must be PTY.")


(provide 'mew-env)
