;;;			     mew-demo.el
;;;
;;;	      Copyright (C) 1996-1997  Kazuhiko Yamamoto
;;;
;;;		   This emacs lisp library conforms
;;;		GNU GENERAL PUBLIC LICENSE Version 2.
;;;
;;; Author:  Kazuhiko Yamamoto <kazu@is.aist-nara.ac.jp>
;;; Created: October  2, 1996
;;; Revised: March   23, 1997
;;;

(defconst mew-demo-version "mew-demo.el version 0.07")

(require 'mew-env)

(defvar mew-demo t
  "*Mew demo is displayed at boot time if non-nil.")

(defvar mew-demo-picture t
  "*A picture of cats is displayed if non-nil on XEmacs.")

(defvar mew-icon-mew "Mew.xpm")

(defvar mew-logo nil)
(defconst mew-buffer-hello      " *mew hello*")

(defconst mew-hello-message 
"

Welcome to Mew world.

Mew -- Messaging in the Emacs World

%s

Copyright (C) 1994-1997 Kazu Yamamoto

Please send comments to kazu@is.aist-nara.ac.jp.

"
)

(defconst mew-error-message 
"

    Sorry, your configuration is *NOT* appropriate for Mew. 
    Please check the following items.

        (1) Does \"~/.mh_profile\" exist?
        (2) Does \"~/.mh_profile\" contain \"Path: Mail\" field?
        (3) Does \"~/.mh_profile\" contain \"Draft-Folder: drafts\" field?
        (4) Does \"~/Mail/drafts\" exist?
        (5) Is the path for MH included in exec-path?
              Put (setq exec-path (cons \"/usr/local/bin/mh\" exec-path))
              in .emacs.
	(6) Is the version of mewencode 0.10?
")

(defconst mew-demo-string
'(
 "/\\\\ - \\\\/"

 "-\\\\ - \\\\/" "\\\\\\ - \\\\/" "|\\\\ - \\\\/" "/\\\\ - \\\\/"
 "-\\\\ - \\\\/" "\\\\\\ - \\\\/" "|\\\\ - \\\\/" "/\\\\ - \\\\/"

 "/|\\ - \\\\/"  "//\\ - \\\\/" "/-\\ - \\\\/" "/\\\\ - \\\\/"
 "/|\\ - \\\\/"  "//\\ - \\\\/"  "/-\\ - \\\\/" "/\\\\ - \\\\/"

 "/\\| - \\\\/" "/\\/ - \\\\/" "/\\- - \\\\/" "/\\\\ - \\\\/" 
 "/\\| - \\\\/" "/\\/ - \\\\/" "/\\- - \\\\/" "/\\\\ - \\\\/"

 "/\\\\ - |\\/" "/\\\\ - /\\/" "/\\\\ - -\\/" "/\\\\ - \\\\/"
 "/\\\\ - |\\/" "/\\\\ - /\\/" "/\\\\ - -\\/" "/\\\\ - \\\\/"

 "/\\\\ - \\|/" "/\\\\ - \\//" "/\\\\ - \\-/" "/\\\\ - \\\\/"
 "/\\\\ - \\|/" "/\\\\ - \\//" "/\\\\ - \\-/" "/\\\\ - \\\\/"

 "/\\\\ - \\\\-" "/\\\\ - \\\\\\" "/\\\\ - \\\\|" "/\\\\ - \\\\/"
 "/\\\\ - \\\\-" "/\\\\ - \\\\\\" "/\\\\ - \\\\|" "/\\\\ - \\\\/"
 )
)

(defun mew-hello ()
  (mew-window-configure (get-buffer-create mew-buffer-hello) '(1 0))
  (let (left-margin fill-column e)
    (erase-buffer)
    (setq left-margin 0)
    (setq fill-column (window-width))
    (insert (format mew-hello-message mew-version))
    (center-region (point-min) (point-max))
    (cond
     (mew-xemacs-p
      (goto-char (point-min))
      (setq e (make-extent (point-min) (point-max)))
      (set-extent-face e 'bold-italic)
      (goto-char (point-max))
      (cond
       ((and mew-icon-p mew-demo-picture)
	(setq mew-logo
	      (make-glyph (vector 'xpm ':file 
				  (expand-file-name mew-icon-mew
						    mew-icon-directory))))
	(indent-to (startup-center-spaces mew-logo))
	(set-extent-begin-glyph (make-extent (point) (point)) mew-logo)
	(goto-char (point-min))
	)
       )
      (sit-for 0) ;; to redraw
      )
     (t
      (insert "/\\\\ - \\\\/")
      (center-line)
      (end-of-line)
      (insert (make-string (1- (- (window-width) (current-column))) ?\ ))
      (end-of-line)
      (sit-for 0) ;; to redraw
      (if mew-demo (mew-demo))
      )
     )
    ))

(defun mew-demo (&optional string)
  (let* ((list (or string mew-demo-string))
	 (wl (window-width))
	 (ul (length (regexp-quote "/\\ - \\/")))
	 (pl (/ (- wl ul) 2))
	 (pre (make-string pl 32))
	 (suf (make-string (1- (- (- wl pl) ul)) 32)))
    (save-window-excursion
      (select-window (get-buffer-window (get-buffer mew-buffer-hello)))
      (while list
	(mew-demo-print (car list) pre suf)
	(mew-demo-loop)
	(setq list (cdr list)))
      )))

(defun mew-demo-print (string prefix suffix)
  (goto-char (point-max))
  (let ((end (point)))
    (beginning-of-line)
    (delete-region (point) end)
    )
  (insert (concat prefix string suffix))
  )

(defun mew-demo-loop ()
  (sit-for 0.02)
  )

(provide 'mew-demo)
