;;;			     mew-cache.el
;;;
;;;		Copyright (C) 1997  Kazuhiko Yamamoto
;;;
;;;		   This emacs lisp library conforms
;;;		GNU GENERAL PUBLIC LICENSE Version 2.
;;;
;;; Author:  Kazuhiko Yamamoto <kazu@is.aist-nara.ac.jp>
;;; Created: March 23, 1997
;;; Revised: April 21, 1997
;;;

(defconst mew-cache-version "mew-cache.el version 0.03")

(require 'mew)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;;  Prepare new message --- caching
;;

(defmacro mew-cache-decode-syntax (buf)
  (` (save-excursion
       (set-buffer (, buf))
       mew-decode-syntax)))

(defmacro mew-cache-decode-error (buf)
  (` (save-excursion
       (set-buffer (, buf))
       mew-decode-error)))

(defvar mew-cache nil
      "Mail cache. (old ... new) order alist with association
 ((\"+folder\" . \"message\") . cache-buffer)"
      )

(defmacro mew-cache-buffer-get (entry)
  (` (cdr (, entry))))

(defmacro mew-cache-folder-get (entry)
  (` (car (car (, entry)))))

(defmacro mew-cache-message-get (entry)
  (` (cdr (car (, entry)))))

(defmacro mew-cache-entry-make (fld-msg buf)
  (` (cons (, fld-msg) (, buf))))

(defmacro mew-cache-hit (fld-msg)
  "Return value assosiated with key."
  (` (mew-cache-buffer-get (assoc (, fld-msg) mew-cache))))

(defun mew-cache-sort (entry)
  (let* ((pointer (cons nil mew-cache))
	 (top pointer))
    (while (cdr pointer)
      (if (equal (car (cdr pointer)) entry)
	  (setcdr pointer (cdr (cdr pointer)))
	(setq pointer (cdr pointer))))
    (setcdr pointer (list entry))
    (setq mew-cache (cdr top))))

(defun mew-cache-add (fld-msg)
  "Rutern associating buffer"
  (let ((len (length mew-cache))
	(buf nil))
    (if (>= len mew-cache-size)
	(prog1
	    (setq buf (mew-cache-buffer-get (car mew-cache)))
	  (setq mew-cache (nconc (cdr mew-cache)
				  (list (mew-cache-entry-make fld-msg buf))))
	  )
      (prog1
	  (setq buf (get-buffer-create 
		     (concat mew-buffer-cache (int-to-string len))))
	(setq mew-cache (nconc mew-cache
				(list (mew-cache-entry-make fld-msg buf))))
	))
    ))

(defun mew-cache-attribute-get (file)
  ;; 5th is modified time
  ;; 7th is file size
  (let ((attr (file-attributes file)))
    (list (nth 5 attr)
	  (nth 7 attr))))
       
(defun mew-cache-message (fld-msg)
  (let ((hit (mew-cache-hit fld-msg))
	(file (mew-expand-file-name (concat (car fld-msg) "/" (cdr fld-msg)))))
    (save-excursion
      (cond
       (hit
	;; cache hit
	(mew-cache-sort (mew-cache-entry-make fld-msg hit))
	(set-buffer hit)
	;; in cache buffer
	(if (null (equal mew-cache-attribute (mew-cache-attribute-get file)))
	    ;; cache is invalid
	    (mew-decode file))
	)
       (t
	;; no cache
	(setq hit (mew-cache-add fld-msg))
	(set-buffer hit)
	;; in cache buffer
	(mew-decode file)
	)
       ))
    hit ;; retrun value
    ))

(defun mew-cache-flush ()
  "A function to flush all decoded messages in cache list."
  (interactive)
  (mew-decode-syntax-delete)
  (let ((n 0))
    (while (< n mew-cache-size)
      (mew-kill-buffer (concat mew-buffer-cache (int-to-string n)))
      (setq n (1+ n))
      ))
  (mew-current-set 'cache nil)
  (setq mew-cache nil)
  )

(provide 'mew-cache)
