;;;			     mew-sort.el
;;;
;;;	     Copyright (C) 1996 and 1997  Takashi P.KATOH
;;;
;;;		   This emacs lisp library confirms
;;;		GNU GENERAL PUBLIC LICENSE Version 2.
;;;
;;; Author:  Takashi P.KATOH <p-katoh@shiratori.riec.tohoku.ac.jp>
;;;          Kazuhiko Yamamoto <kazu@is.aist-nara.ac.jp>
;;; Created: Febraury  6, 1996
;;; Revised: March    28, 1997
;;;

(defconst mew-sort-version "mew-sort.el version 0.04")

(require 'mew)

(defvar mew-summary-sort-fields
  '(("date" . t) ("subject") ("from") ("to") ("newsgroups") ("posted" . t))
  "*List of fields for `mew-summary-sort'.
Each element is (FIELD-NAME) or (FIELD-NAME . DATE-P).
If DATE-P is non-nil, messages will be sorted by chronological order.")

(defvar mew-summary-sort-last-field "date")

(defun mew-summary-sort-subr (msgs &optional method)
  (let* ((folder (buffer-name))
	 (msgs (if (listp msgs) msgs (list msgs)))
	 (completion-ignore-case t)
	 (field
	  (completing-read
	   (concat "Sort " method (if method " ") "by?"
		   (if mew-summary-sort-last-field
		       (concat " (default " mew-summary-sort-last-field "): ")
		     ": ")) mew-summary-sort-fields)))
    (setq field
	  (downcase
	   (if (string-equal field "") mew-summary-sort-last-field field))
	  mew-summary-sort-last-field field)
    (if (null (mew-summary-exclusive-p))
	()
      (if (mew-summary-mark-exist-p (list mew-mark-rmm mew-mark-refile))
	  (if (mew-y-or-n-p
	       "Marked messages exist. Process mark before scan? ")
	      (mew-summary-exec)))
      (setq mew-summary-buffer-process t)
      (message "Sorting %s by %s ... " folder field)
      (if (cdr (assoc field mew-summary-sort-fields))
	  (apply 'call-process mew-prog-sortm nil nil nil
		 (append (list folder) msgs (list "-datefield" field)))
	(apply 'call-process mew-prog-sortm nil nil nil
	       (append (list folder)
		       msgs
		       (list "-textfield" field "-limit" "0"))))
      (message "Sorting %s by %s ... done" folder field)
      (setq mew-summary-buffer-process nil)
      (let ((buffer-read-only nil)) (erase-buffer));; for update
      (mew-summary-scan-body folder (mew-input-range folder))
      )
    ))

(defun mew-summary-sort (&optional arg)
  (interactive "P")
  (if arg
      (mew-summary-sort-region (region-beginning) (region-end) "region")
    (mew-summary-sort-region (point-min) (point-max))))

(defun mew-summary-sort-region (r1 r2 &optional method)
  (interactive "r")
  (let (from to msgs)
    (save-excursion
      (goto-char r1)
      (setq from
	    (or (mew-summary-message-number)
		(progn
		  (re-search-backward mew-summary-message-regex nil t nil)
		  (mew-summary-message-number))))
      (goto-char r2)
      (setq to
	    (or (mew-summary-message-number)
		(progn
		  (re-search-backward mew-summary-message-regex nil t nil)
		  (mew-summary-message-number))))
      (if (< (string-to-int from) (string-to-int to))
	  (mew-summary-sort-subr (concat from "-" to) method)
	(mew-summary-sort-subr (concat to "-" from) method)))))

(defun mew-summary-mark-sort (&optional r1 r2)
  (interactive)
  (mew-summary-sort-subr
   (mew-summary-mark-collect
    mew-mark-hop (or r1 (point-min)) (or r2 (point-max)))
   "marked messages"))

(provide 'mew-sort)
